@extends('layout')
@section('content')
@include('partials.breadcrumb')

<!-- blog post begin-->
<div class="blog-post single-blog-post">
    <div class="container">
        <div class="row">

            <div class="col-xl-8 col-lg-8">
                <div class="row">
                    <div class="col-xl-12 col-lg-12 col-md-12">
                        <div class="single-blog blog-details">
                            <div class="post-shadow">
                                <div class="part-img">
                                    <img src="{{asset('assets/images/post/'.$post->image)}}" alt="{{__($post->title)}}">
                                </div>
                                <div class="part-text">
                                    <h3><a href="{{route('blog.details',[$post->id, str_slug($post->title)])}}">{{__($post->title)}}</a></h3>
                                    <h4>
                                        <span class="date"> {{date('d M, Y',strtotime($post->created_at))}}</span>
                                    </h4>
                                    {!! $post->details !!}


                                </div>
                            </div>

                            <div class="comment-area">
                                <div class="comment-shadow">
                                    <div class="fb-comments" data-colorscheme="dark" data-width="100%" data-href="{{url()->current()}}" data-numposts="5"></div>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>


            <div class="col-xl-4 col-lg-4 col-md-12">
                <div class="sidebar">
                    <div class="row">
                        @include('partials.category')
                        @include('partials.popular-post')
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<!-- blog post end -->


@stop